<?php
session_start();
include 'db_connection.php';

// Initialize variables
$letter_number = $letter_date = $department = $subject = $branch_id = $role = $user_id = $scan_copy = $hod_comment = $priority = "";
$error_message = "";
$success_message = "";

// Fetch branches
$branches = $conn->query("SELECT branch_id, branch_name FROM branches");

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $letter_number = $_POST['letter_number'];
    $letter_date = $_POST['letter_date'];
    $department = $_POST['department'];
    $subject = $_POST['subject'];
    $branch_id = $_POST['branch_id'];
    $role = $_POST['role'];
    $user_id = $_POST['user_id'];
    $hod_comment = $_POST['hod_comment'];
    $priority = $_POST['priority'];

    // Upload file
    if (isset($_FILES['scan_copy']) && $_FILES['scan_copy']['error'] == 0) {
        $scan_copy = 'uploads/' . basename($_FILES['scan_copy']['name']);
        if (!move_uploaded_file($_FILES['scan_copy']['tmp_name'], $scan_copy)) {
            $error_message = "Error uploading the scan copy.";
        }
    } else {
        $scan_copy = NULL;
    }

    // Insert into DB
    if (empty($error_message)) {
        $query = "INSERT INTO letters (letter_number, letter_date, department, subject, branch_id, role, user_id, scan_copy, hod_comment, priority)
                  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        if ($stmt = $conn->prepare($query)) {
            $stmt->bind_param("ssssisis", $letter_number, $letter_date, $department, $subject, $branch_id, $role, $user_id, $scan_copy, $hod_comment, $priority);
            if ($stmt->execute()) {
                $success_message = "Letter added successfully!";
                $letter_number = $letter_date = $department = $subject = $branch_id = $role = $user_id = $scan_copy = $hod_comment = $priority = "";
            } else {
                $error_message = "Error: " . $stmt->error;
            }
            $stmt->close();
        } else {
            $error_message = "Error preparing query: " . $conn->error;
        }
    }

    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Enter Letter - Letter Admin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Bootstrap -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
    <!-- Select2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    
    <style>
        body {
            background-color: #f8f9fa;
            padding: 20px;
        }
        .card {
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .select2-container--default .select2-selection--single {
            height: 38px;
            padding: 6px 12px;
            border: 1px solid #ced4da;
            border-radius: 4px;
        }
    </style>
</head>
<body>

<div class="container">
    <h2 class="mb-3">Enter Letter - Letter Admin</h2>
    
    <?php if ($success_message): ?>
        <div class="alert alert-success"><?php echo $success_message; ?></div>
    <?php endif; ?>
    
    <?php if ($error_message): ?>
        <div class="alert alert-danger"><?php echo $error_message; ?></div>
    <?php endif; ?>

    <div class="card">
        <div class="card-body">
            <form method="POST" enctype="multipart/form-data">

                <div class="form-group">
                    <label for="letter_number">Letter Number:</label>
                    <input type="text" class="form-control" name="letter_number" value="<?= $letter_number ?>" required>
                </div>

                <div class="form-group">
                    <label for="letter_date">Letter Date:</label>
                    <input type="date" class="form-control" name="letter_date" value="<?= $letter_date ?>" required>
                </div>

                <div class="form-group">
                    <label for="department">Department:</label>
                    <input type="text" class="form-control" name="department" value="<?= $department ?>" required>
                </div>

                <div class="form-group">
                    <label for="subject">Subject:</label>
                    <input type="text" class="form-control" name="subject" value="<?= $subject ?>" required>
                </div>

                <div class="form-group">
                    <label for="branch_id">Branch:</label>
                    <select class="form-control" name="branch_id" id="branch_id" required>
                        <option value="">Select Branch</option>
                        <?php while ($branch = $branches->fetch_assoc()): ?>
                            <option value="<?= $branch['branch_id'] ?>" <?= $branch_id == $branch['branch_id'] ? 'selected' : '' ?>>
                                <?= $branch['branch_name'] ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="role">Role:</label>
                    <select class="form-control" name="role" required>
                        <option value="branch_head" <?= $role == 'branch_head' ? 'selected' : '' ?>>Branch Head</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="user_id">User ID (Branch Head):</label>
                    <select class="form-control" name="user_id" id="user_id" required>
                        <option value="">Select User</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="scan_copy">Scan Copy (PDF/JPG):</label>
                    <input type="file" class="form-control-file" name="scan_copy" accept=".pdf,.jpg,.jpeg,.png">
                </div>

                <!-- New fields for hod_comment and priority -->
                <div class="form-group">
                    <label for="hod_comment">HOD Comment:</label>
                    <textarea class="form-control" name="hod_comment" rows="3" required><?= $hod_comment ?></textarea>
                </div>

                <div class="form-group">
                    <label for="priority">Priority:</label>
                    <select class="form-control" name="priority" required>
                        <option value="Low" <?= $priority == 'Low' ? 'selected' : '' ?>>Low</option>
                        <option value="Medium" <?= $priority == 'Medium' ? 'selected' : '' ?>>Medium</option>
                        <option value="High" <?= $priority == 'High' ? 'selected' : '' ?>>High</option>
                    </select>
                </div>

                <button type="submit" class="btn btn-success btn-block"><i class="fas fa-save"></i> Save Letter</button>
            </form>
        </div>
    </div>

    <a href="letter_admin_dashboard.php" class="btn btn-secondary mt-3"><i class="fas fa-arrow-left"></i> Back</a>
</div>

<!-- JS Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
    $(document).ready(function () {
        $('#user_id').select2({ placeholder: "Select User", width: '100%' });

        $('#branch_id').on('change', function () {
            let branchId = $(this).val();
            if (branchId) {
                $.get('get_users.php', { branch_id: branchId }, function (data) {
                    $('#user_id').html(data).val(null).trigger('change');
                });
            } else {
                $('#user_id').html('<option value="">Select User</option>').trigger('change');
            }
        });
    });
</script>

</body>
</html>
