<?php
// Include the database connection file
include('db_connection.php');

// Check if file_id is set
if (isset($_GET['file_id'])) {
    $file_id = $_GET['file_id'];

    // Query to fetch file details
    $query = "SELECT fm.*, b.branch_name, u.username AS user_name 
              FROM file_management fm
              JOIN branches b ON fm.branch_id = b.branch_id
              JOIN users u ON fm.user_id = u.user_id
              WHERE fm.file_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $file_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $file = $result->fetch_assoc();
    } else {
        echo "File details not found.";
        exit;
    }
} else {
    echo "No file ID provided.";
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>File Details</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
        }
        .container {
            max-width: 900px;
            margin-top: 50px;
        }
        .file-details {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .file-details label {
            font-weight: bold;
        }
        .file-details p {
            margin-bottom: 10px;
        }
        .back-button {
            background-color: #f44336;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .back-button:hover {
            background-color: #e53935;
        }
        .card-header {
            background-color: #f8f9fa;
        }
        .file-details .row {
            margin-bottom: 10px;
        }
        .file-details .row .col-md-4 {
            text-align: right;
        }
        .file-details .row .col-md-8 {
            text-align: left;
        }
    </style>
</head>
<body>

<div class="container">
    <!-- Back Button -->
    <a href="file_management_view.php" class="back-button">Back to File Management</a>

    <!-- File Details Card -->
    <div class="card file-details">
        <div class="card-header">
            <h3>File Details</h3>
        </div>
        <div class="card-body">
            <!-- File details displayed in rows -->
            <div class="row">
                <div class="col-md-4">
                    <label>File Name:</label>
                </div>
                <div class="col-md-8">
                    <p><?php echo htmlspecialchars($file['file_name']); ?></p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <label>File Number:</label>
                </div>
                <div class="col-md-8">
                    <p><?php echo htmlspecialchars($file['file_number']); ?></p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <label>Subject:</label>
                </div>
                <div class="col-md-8">
                    <p><?php echo htmlspecialchars($file['subject']); ?></p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <label>Branch:</label>
                </div>
                <div class="col-md-8">
                    <p><?php echo htmlspecialchars($file['branch_name']); ?></p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <label>User:</label>
                </div>
                <div class="col-md-8">
                    <p><?php echo htmlspecialchars($file['user_name']); ?></p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <label>Status:</label>
                </div>
                <div class="col-md-8">
                    <p><?php echo htmlspecialchars($file['status']); ?></p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <label>Cupboard Name:</label>
                </div>
                <div class="col-md-8">
                    <p><?php echo htmlspecialchars($file['cupboard_name']); ?></p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <label>Rack Name:</label>
                </div>
                <div class="col-md-8">
                    <p><?php echo htmlspecialchars($file['rack_name']); ?></p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <label>Folder Name:</label>
                </div>
                <div class="col-md-8">
                    <p><?php echo htmlspecialchars($file['folder_name']); ?></p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <label>File Order Number:</label>
                </div>
                <div class="col-md-8">
                    <p><?php echo htmlspecialchars($file['file_order_number']); ?></p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <label>Created At:</label>
                </div>
                <div class="col-md-8">
                    <p><?php echo htmlspecialchars($file['created_at']); ?></p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- Redirect user back to file_management_view.php on modal close or back button -->
<script>
    // Close the modal and redirect to the file management view
    var closeButton = document.querySelector('.btn-close');
    closeButton.addEventListener('click', function () {
        window.location.href = 'file_management_view.php';
    });
</script>

</body>
</html>
