<?php
// Include database connection
include '..\db_connection.php';

// Start session and check if the user is logged in
session_start();
if (!isset($_SESSION['user_id'])) {
    echo "<p>You need to be logged in to view the letters.</p>";
    exit;
}

// Fetch rejected letters for the specific approver (status = 'rejected')
$query = "SELECT draft_id, draft_number, subject, department, status, attachment 
          FROM letter_drafts 
          WHERE approver_id = ? AND status = 'rejected'"; 
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $_SESSION['user_id']); // Use the approver's user ID from the session
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Rejected Letters</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
</head>
<body>
    <div class="container">
        <h2 class="mt-4">View Rejected Letters</h2>

        <!-- Display message if set -->
        <?php if (isset($_SESSION['message'])): ?>
            <div class="alert alert-info"><?php echo $_SESSION['message']; ?></div>
            <?php unset($_SESSION['message']); // Clear the message after displaying it ?>
        <?php endif; ?>

        <?php if ($result->num_rows > 0): ?>
            <table class="table">
                <thead>
                    <tr>
                        <th>Draft Number</th>
                        <th>Subject</th>
                        <th>Department</th>
                        <th>Status</th>
                        <th>Attachment</th> <!-- Attachment Column -->
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $row['draft_number']; ?></td>
                            <td><?php echo $row['subject']; ?></td>
                            <td><?php echo $row['department']; ?></td>
                            <td><?php echo $row['status']; ?></td>
                            <td>
                                <?php if ($row['attachment']): ?>
                                    <!-- Display the download button if there is an attachment -->
                                    <a href="<?php echo $row['attachment']; ?>" class="btn btn-info btn-sm" download>Download Attachment</a>
                                <?php else: ?>
                                    No attachment
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>No rejected letters found.</p>
        <?php endif; ?>
    </div>

    <!-- Bootstrap JS and dependencies -->
    <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
</body>
</html>
