<?php
// Start the session
session_start();

// Ensure the user is logged in
if (!isset($_SESSION['user_id'])) {
    // Redirect to login page if the user is not logged in
    header("Location: login.php");
    exit;
}

// Get the logged-in user's details from the session
$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];  // Get the role from the session
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Unauthorized Access</title>
    
    <!-- Include Bootstrap CSS for styling -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f9fd;
            padding: 50px;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .container {
            text-align: center;
            background-color: #fff;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            width: 80%;
            max-width: 600px;
        }
        .alert {
            font-size: 18px;
        }
        .btn-back {
            margin-top: 20px;
            background-color: #f44336;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
        }
        .btn-back:hover {
            background-color: #e53935;
        }
    </style>
</head>
<body>

<div class="container">
    <div class="alert alert-danger" role="alert">
        <h4 class="alert-heading">Unauthorized Access!</h4>
        <p>You do not have the necessary permissions to access this page.</p>
        <hr>
        <p class="mb-0">If you believe this is an error, please contact your system administrator.</p>
    </div>

    <?php
    // Determine the Back button's URL based on the user's role
    if ($role == 'super_admin') {
        $back_url = 'super_admin_dashboard.php';  // Redirect to Super Admin Dashboard
    } elseif ($role == 'branch_head') {
        $back_url = 'branch_head_dashboard.php';  // Redirect to Branch Head Dashboard
    } else {
        $back_url = 'staff_user_dashboard.php';  // Redirect to Staff User Dashboard
    }
    ?>

    <!-- Role-based Back Button -->
    <a href="<?php echo $back_url; ?>" class="btn btn-back">Back to Dashboard</a>
</div>

<!-- Include Bootstrap JS for modal functionality if needed -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
